varying vec2 texCoord;

uniform sampler2D colorMap;
uniform sampler2D paletteMap;
uniform sampler2D stencilMap;

uniform float flash;

void main (void)
{
    vec4 color = texture2D(colorMap, texCoord);
    float a = (color.r+color.g+color.b)/3.0f;
    a=clamp (a,0.0f+1.0/256.0f,1.0f-1.0/256.0f);
    //a=clamp (a,0.5f,0.55f);
	vec4 color2 = texture2D(paletteMap, vec2(a,0.0f));

	float stencil=texture2D(stencilMap, texCoord).r;

	vec4 rescolor = color2*stencil + color*(1.0f-stencil);
	rescolor+=vec4(flash);

	gl_FragColor = rescolor;
}
